unit remotefibssserver;

interface

uses
  SysUtils, Classes, IdBaseComponent, IdComponent, IdTCPServer,
  {$IFDEF WIN32}Windows,Forms,{$ELSE}LibC,{$ENDIF}CfgBackup, ctrlBackup;
type
  TRemoteServerModule = class(TDataModule)
    IdServer: TIdTCPServer;
    procedure HandShakeCommand(ASender: TIdCommand);
    procedure ReadConfigCommand(ASender: TIdCommand);
    procedure WriteConfigCommand(ASender: TIdCommand);
    procedure ReadDefaultsCommand(ASender: TIdCommand);
    procedure WriteDefaultsCommand(ASender: TIdCommand);
    procedure EnumEntriesCommand(ASender: TIdCommand);
    procedure DeleteEntryCommand(ASender: TIdCommand);
    procedure GetBackupServiceStatusCommand(ASender: TIdCommand);
    procedure StartBackupServiceCommand(ASender: TIdCommand);
    procedure StopBackupServiceCommand(ASender: TIdCommand);
    procedure PauseBackupServiceCommand(ASender: TIdCommand);
    procedure ContinueBackupServiceCommand(ASender: TIdCommand);
    procedure ReloadBackupServiceCommand(ASender: TIdCommand);
  private
    { Private declarations }
    FClientVersion : Integer;
  public
    { Public declarations }
  end;

var
  RemoteServerModule: TRemoteServerModule;

implementation

{$R *.dfm}

Const
  ServerVersion = 2;

procedure TRemoteServerModule.ReadConfigCommand(ASender: TIdCommand);
var
  Conf:TBackupConfig;
begin
  //Read Config command
  if CfgBackup.ReadConfig(ASender.Params[0]{Entry Name},Conf) then
  begin
    ASender.Response.Add(Conf.ServerName);
    ASender.Response.Add(Conf.DatabasePath);
    ASender.Response.Add(Conf.BackupFile);
    ASender.Response.Add(Conf.UserName);
    ASender.Response.Add(Conf.Password);
    ASender.Response.Add(Conf.LogFileName);
    ASender.Response.Add(BackupOptionsToString(Conf.Options));
    ASender.Response.Add(IntToStr(Ord(Conf.Skip)));
    ASender.Response.Add(IntToStr(Ord(Conf.CompressBackup)));
    If FCLientversion>1 then
      ASender.Response.Add(IntToStr(Conf.DaysOfWeek));
  end
  else
    ASender.Response.Add('CANCEL');
end;

procedure TRemoteServerModule.WriteConfigCommand(ASender: TIdCommand);
var
  Conf:TBackupConfig;
begin
  //Write Config Command
  Conf.ServerName:=Trim(ASender.Params[1]);
  Conf.DatabasePath:=Trim(ASender.Params[2]);
  Conf.BackupFile:=Trim(ASender.Params[3]);
  Conf.UserName:=Trim(ASender.Params[4]);
  Conf.Password:=Trim(ASender.Params[5]);
  Conf.LogFileName:=Trim(ASender.Params[6]);
  Conf.Options:=StringToBackupOptions(Trim(ASender.Params[7]));
  Conf.Skip:=Boolean(StrToIntDef(ASender.Params[8],0));
  Conf.CompressBackup:=Boolean(StrToIntDef(ASender.Params[9],0));
  // Client sent also params..
  If (FClientVersion>1) then
    Conf.DaysOfWeek:=StrToIntDef(ASender.Params[10],0);
  if CfgBackup.WriteConfig(ASender.Params[0],Conf) then
    ASender.Response.Add('OK')
  else
    ASender.Response.Add('CANCEL');
end;

procedure TRemoteServerModule.ReadDefaultsCommand(ASender: TIdCommand);
var
  Conf:TBackupDefaults;
begin
  //READ Defaults command
  if CfgBackup.ReadDefaults(Conf) then
  begin
    ASender.Response.Add(Conf.BackupDir);
    ASender.Response.Add(Conf.LogDir);
    ASender.Response.Add(Conf.BackupExt);
    ASender.Response.Add(FormatDateTime('hhnnss',Conf.BackupTime));
  end
  else
    ASender.Response.Add('CANCEL');

end;

procedure TRemoteServerModule.WriteDefaultsCommand(
  ASender: TIdCommand);
var
  Conf:TBackupDefaults;
  TimeStr:String;
begin
  //Write Defaults
  try
    Conf.BackupDir:=Trim(ASender.Params[0]);
    Conf.LogDir:=Trim(ASender.Params[1]);
    Conf.BackupExt:=Trim(ASender.Params[2]);
    TimeStr:=ASender.Params[3];  //Time string has the following format:  hhmmss - without any delimiters.
    Conf.BackupTime:=EncodeTime(StrToIntDef(Copy(TimeStr,1,2),0),StrToInt(Copy(TimeStr,3,2)),StrToIntDef(Copy(TimeStr,5,2),0),0);
  except
    //server returns ERROR in case of wrong parameters
    on e:Exception do
    begin
      ASender.Response.Add('ERROR');
      ASender.Response.Add(E.message);
      Exit;
    end;
  end;
  if CfgBackup.WriteDefaults(Conf) then
    ASender.Response.Add('OK')
  else
    ASender.Response.Add('CANCEL');

end;

procedure TRemoteServerModule.EnumEntriesCommand(ASender: TIdCommand);
var
  Lst:TStringList;
  i: Integer;
begin
  //Enum Entries
  Lst:=TStringList.Create;
  if CfgBackup.EnumEntries(Lst) then
  begin
    ASender.Response.Add(IntToStr(Lst.Count));
    for i := 0 to Lst.Count - 1 do
      ASender.Response.Add(Lst[i]);
  end
  else
    ASender.Response.Add('CANCEL');
  Lst.Free;
end;

procedure TRemoteServerModule.DeleteEntryCommand(ASender: TIdCommand);
begin
  //Delete Entry
  if CfgBackup.DeleteEntry(ASender.Params[0]) then
    ASender.Response.Add('OK')
  else
    ASender.Response.Add('CANCEL');
end;

procedure TRemoteServerModule.GetBackupServiceStatusCommand(
  ASender: TIdCommand);
var
  Status:TBackupServiceStatus;
begin
  //Get Backup Service Status
  Status:=GetBackupServiceStatus;
  ASender.Response.Add(BackupServiceStatusNames[Status]);
end;

procedure TRemoteServerModule.StartBackupServiceCommand(
  ASender: TIdCommand);
begin
  //Start Backup Service
  StartBackupService;
  Asender.PerformReply:=False;
end;

procedure TRemoteServerModule.StopBackupServiceCommand(
  ASender: TIdCommand);
begin
  StopBackupService;
  Asender.PerformReply:=False;
end;

procedure TRemoteServerModule.PauseBackupServiceCommand(
  ASender: TIdCommand);
begin
  PauseBackupService;
  Asender.PerformReply:=False;
end;

procedure TRemoteServerModule.ContinueBackupServiceCommand(
  ASender: TIdCommand);
begin
  ContinueBackupService;
  Asender.PerformReply:=False;
end;

procedure TRemoteServerModule.ReloadBackupServiceCommand(
  ASender: TIdCommand);
begin
  ReloadBackupService;
  Asender.PerformReply:=False;
end;
procedure TRemoteServerModule.HandShakeCommand(ASender: TIdCommand);
var
  Buf:array[0..255] of Char;
{$IFDEF WIN32}
  Size:DWORD;
{$ENDIF}  
begin
  If ASender.Params.Count=0 then
    FClientVersion:=1
  else
    FClientVersion:=StrToIntDef(ASender.Params[0],1);
  ASender.Response.Add('2');            //Number of lines that will come
  ASender.Response.Add('version='+IntToStr(ServerVersion));
  {$IFDEF WIN32}
  Size:=254;
  GetComputerName(Buf, Size);
  {$ELSE}
  GetHostName(Buf,254);
  {$ENDIF}
  ASender.Response.Add('servername='+StrPas(Buf));
end;

end.
