unit remotefibssclient;

interface

uses CfgBackup,ctrlBackup,Classes, IdTCPClient, IdGlobal, SysUtils;

{----  HandShake procedure -----}
procedure ProcessHandshake(idClient: TidTCPClient);//Should be called just after connect...
{ ---------------------------------------------------------------------
  Remote configuration calls
  ---------------------------------------------------------------------}
//idClient :TidTCPClient - should be already connected to remotefibss service...
Function ReadRemoteConfig(idClient: TidTCPClient; Entry : String; Var Config : TBackupConfig) : Boolean; overload;
Function WriteRemoteConfig(idClient: TidTCPClient; Entry : String; Const Config : TBackupConfig) : Boolean; overload;
Function ReadRemoteDefaults(idClient: TidTCPClient; Var Config : TBackupDefaults) : boolean;
Function WriteRemoteDefaults(idClient: TidTCPClient; Var Config : TBackupDefaults) : Boolean;
Function EnumRemoteEntries(idClient: TidTCPClient; List : TStrings) : Boolean;
Function DeleteRemoteEntry(idClient: TidTCPClient; Entry : String) : Boolean;

{ ---------------------------------------------------------------------
  Remote control calls
  ---------------------------------------------------------------------}
// These can raise an exception.
Function GetRemoteBackupServiceStatus(idClient: TidTCPClient) : TBackupServiceStatus;
Procedure StartRemoteBackupService(idClient: TidTCPClient);
Procedure StopRemoteBackupService(idClient: TidTCPClient);
Procedure PauseRemoteBackupService(idClient: TidTCPClient);
Procedure ContinueRemoteBackupService(idClient: TidTCPClient);
Procedure ReloadRemoteBackupService(idClient: TidTCPClient);

var
  RemoteServerVersion:Integer;
  RemoteServerName:String;

implementation

Const
  ClientVersion = 2;

procedure ProcessHandshake(idClient: TidTCPClient);//Should be called just after connect...
var
  S: string;
  LineCount:Integer;
  Option,Value:String;
  i: Integer;
begin
  idClient.WriteLn('HANDSHAKE*'+IntToStr(ClientVersion));
  s:=idClient.Readln(EOL);
  LineCount:=StrToInt(s);       //Number of lines that will come.
  for i := 0 to LineCount - 1 do
  begin
    s:=idClient.Readln(EOL);
    Option:=Copy(s,1,Pos('=',s)-1);
    Value:=Copy(s,Pos('=',s)+1,maxint);
    //Loading values to the internal variables
    if Option='version' then
      RemoteServerVersion:=StrToInt(Value);
    if Option='servername' then
      RemoteServerName:=Value;
  end;
  idClient.Readln(EOL); //Skipping final '.' character
end;
//This function replaces empty string on space because server will not accept empty parameters.
//On the server side parameter values are trimmed.
function RemoteParam(const Value:String):String;
begin
  if Value='' then
    Result:=' '
  else
    Result:=Value;
end;

Function ReadRemoteConfig(idClient: TidTCPClient; Entry : String; Var Config : TBackupConfig) : Boolean; overload;
var
  S: string;
begin
  idClient.WriteLN('READCONFIG*'+Entry);
  //This command returns 9 lines or CANCEL
  s:=idClient.Readln(EOL);
  Result:=s<>'CANCEL';
  if not Result then
  begin
    idClient.Readln(EOL);//Read trailing point (idServer finished transmission with '.')
    Exit;
  end;
  Config.ServerName:=s;
  Config.DatabasePath:=idClient.Readln(EOL);
  Config.BackupFile:=idClient.Readln(EOL);
  Config.UserName:=idClient.Readln(EOL);
  Config.Password:=idClient.Readln(EOL);
  Config.LogFileName:=idClient.Readln(EOL);
  Config.Options:=StringToBackupOptions(idClient.Readln(EOL));
  Config.Skip:=Boolean(StrToInt(idClient.Readln(EOL)));
  Config.CompressBackup:=Boolean(StrToInt(idClient.Readln(EOL)));
  If (RemoteServerVersion>1) then
    begin
    Config.DaysOfWeek:=StrToIntDef(idClient.Readln(EOL),0);
    end;
  idClient.Readln(EOL);
end;

Function WriteRemoteConfig(idClient: TidTCPClient; Entry : String; Const Config : TBackupConfig) : Boolean; overload;
var
  CommandStr:String;
begin
  CommandStr:='WRITECONFIG*'+Entry+'*'+
              RemoteParam(Config.ServerName)+'*'+
              RemoteParam(Config.DatabasePath)+'*'+
              RemoteParam(Config.BackupFile)+'*'+
              RemoteParam(Config.UserName)+'*'+
              RemoteParam(Config.Password)+'*'+
              RemoteParam(Config.LogFileName)+'*'+
              RemoteParam(BackupOptionsToString(Config.Options))+'*'+
              IntToStr(Integer(Config.Skip))+'*'+
              IntToStr(Integer(Config.CompressBackup));
  If (RemoteServerVersion>1) then
    CommandStr:=CommandStr+'*'+
                IntToStr(Config.DaysOfWeek);
  idClient.WriteLN(CommandStr);
  CommandStr:=idClient.ReadLN(EOL);
  Result:=CommandStr='OK';
  idClient.Readln(EOL);
end;

Function ReadRemoteDefaults(idClient: TidTCPClient; Var Config : TBackupDefaults) : boolean;
var
  S: string;
begin
  //Server returns 4 lines
  idClient.WriteLn('READDEFAULTS');
  s:=idClient.Readln(EOL);
  Result:=s<>'CANCEL';
  if not Result then
  begin
    idClient.Readln(EOL);
    Exit;
  end;
  Config.BackupDir:=s;
  Config.LogDir:=idClient.Readln(EOL);
  Config.BackupExt:=idClient.Readln(EOL);
  s:=idClient.Readln(EOL);//Backup Time with "hhmmss" format
  Config.BackupTime:=EncodeTime(StrToInt(Copy(s,1,2)),StrToInt(Copy(s,3,2)),StrToInt(Copy(s,5,2)),0);
  idClient.Readln(EOL);//'.'
end;

Function WriteRemoteDefaults(idClient: TidTCPClient; Var Config : TBackupDefaults) : Boolean;
var
  CommandStr:String;
begin
  CommandStr:='WRITEDEFAULTS*'+
              RemoteParam(Config.BackupDir)+'*'+
              RemoteParam(Config.LogDir)+'*'+
              RemoteParam(Config.BackupExt)+'*'+
              FormatDateTime('hhnnss',Config.BackupTime);
  idClient.WriteLN(CommandStr);
  Result:=idClient.ReadLN(EOL)='OK';
  idClient.Readln(EOL);//'.'
end;

Function EnumRemoteEntries(idClient: TidTCPClient; List : TStrings) : Boolean;
var
  i, Count:Integer;
begin
  idClient.WriteLN('ENUMENTRIES');
  Count:=StrToInt(idClient.ReadLn(EOL));//First line contains items count
  for i := 1 to Count do
    List.Add(idClient.ReadLn(EOL));
  Result:=True;
  idClient.Readln(EOL);//'.'
end;

Function DeleteRemoteEntry(idClient: TidTCPClient; Entry : String) : Boolean;
begin
  idClient.WriteLN('DELETEENTRY*'+Entry);
  Result:=idClient.ReadLN(EOL)='OK';
end;

Function GetRemoteBackupServiceStatus (idClient: TidTCPClient): TBackupServiceStatus;
var
  Status:String;
  i: TBackupServiceStatus;
begin
  idClient.Writeln('GETBACKUPSERVICESTATUS');
  Status:=idClient.ReadLN(EOL);
  idClient.Readln(EOL);//'.'
  Result:=bssUnknown;
  for i := Low(TBackupServiceStatus) to High(TBackupServiceStatus) do    // Iterate
    if BackupServiceStatusNames[i]=Status then
    begin
      Result:=i;
      Exit;
    end;
end;

Procedure StartRemoteBackupService(idClient: TidTCPClient);
begin
  idClient.WriteLN('STARTBACKUPSERVICE');
end;

Procedure StopRemoteBackupService(idClient: TidTCPClient);
begin
  idClient.WriteLN('STOPBACKUPSERVICE');
end;

Procedure PauseRemoteBackupService(idClient: TidTCPClient);
begin
  idClient.WriteLN('PAUSEBACKUPSERVICE');
end;

Procedure ContinueRemoteBackupService(idClient: TidTCPClient);
begin
  idClient.WriteLN('CONTINUEBACKUPSERVICE');
end;

Procedure ReloadRemoteBackupService(idClient: TidTCPClient);
begin
  idClient.WriteLN('RELOADBACKUPSERVICE');
end;

end.
