program decomp;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  UDecomp in 'UDecomp.pas';

ResourceString
  SErrNeedArgument = 'Option at position %d (%s) needs an argument';
  SUnknownArgument = 'Unknown argument at position %d: %s';
  SExtraArgument   = 'Extra argument at position %d: %s';
  SErrConstructingOutputFileName
                   = 'Could not determine output filename from input: %s';

Var
  InputfileName   : String;
  OutputfileName  : String;
  DeleteSource    : Boolean;
  BufSize         : Integer;
  ConsoleOutput   : Boolean;

Procedure Usage;

begin
  Writeln('Usage : ',ExtractFileName(Paramstr(0)),' [-b size] [-l] [-c] [[-i] Infile] [[-o] Outfile]');
  Writeln(' --bufsize=size,');
  Writeln(' -b size   Buffer size (in Kb)');
  Writeln(' --help,');
  Writeln(' -h        This help message');
  Writeln(' --leavesource,');
  Writeln(' -l        Leave source file (do not delete)');
  Writeln(' --console,');
  Writeln(' -c        Output to console (default if no filename)');
  Writeln(' --input=name,');
  Writeln(' -i name   Input filename (empty for stdin)');
  Writeln(' --output=name,');
  Writeln(' -o name   Output filename (inputfilename stripped from extension)');
  Halt(1)
end;

Procedure DoError(Msg : String; Args : Array of const);

begin
  Writeln(Format(Msg,Args));
  Usage;
end;



Procedure ProcessCommandLine;

 Function CheckOption(Index : Integer;Short,Long : String): Boolean;

  var
    O : String;

  begin
    O:=Paramstr(Index);
    Result:=(O='-'+short) or (copy(O,1,Length(Long)+3)=('--'+long+'='));
  end;

  Function OptionArg(Var Index : Integer) : String;

  Var
    P : Integer;

  begin
    if (Length(ParamStr(Index))>1) and (Paramstr(Index)[2]<>'-') then
      begin
      If Index<ParamCount then
        begin
        Inc(Index);
        Result:=Paramstr(Index);
        end
      else
        DoError(SErrNeedArgument,[Index,ParamStr(Index)]);
      end
    else If length(ParamStr(Index))>2 then
      begin
      P:=Pos('=',Paramstr(Index));
      If (P=0) then
        DoError(SErrNeedArgument,[Index,ParamStr(Index)])
      else
        begin
        Result:=Paramstr(Index);
        Delete(Result,1,P);
        end;
      end;
  end;

Var
  I : Integer;
  S : String;

begin
  InputFileName:='';
  OutputFileName:='';
  DeleteSource:=True;
  BufSize:=0;
  ConsoleOutput:=False;
  I:=0;
  While (I<ParamCount) do
    begin
    Inc(I);
    // Values.
    If Checkoption(I,'o','output') then
      OutputFileName:=OptionArg(I)
    else If Checkoption(I,'i','input') then
      InputFileName:=OptionArg(I)
    else If CheckOption(I,'c','console') then
      ConsoleOutput:=True
    else If CheckOption(I,'b','bufsize') then
      BufSize:=StrToIntDef(OptionArg(I),0)
    else If CheckOption(I,'l','leavesource') then
      DeleteSource:=False
    else If CheckOption(I,'h','help') then
      Usage
    else
      If (Length(Paramstr(I))>0) and
         (Paramstr(I)[1]<>'-') then
        begin
        if (InputFileName='') then
          InputFileName:=ParamStr(I)
        else
          if (OutputFileName='') then
            OutputFileName:=Paramstr(I)
          else
            DoError(SExtraArgument,[I,ParamStr(I)])
        end
      else
        DoError(SUnknownArgument,[I,ParamStr(I)])
    end;
  If (InputFileName<>'') then
    begin
    If (OutputFileName='') and Not ConsoleOutput then
      begin
      OutputFileName:=DetermineOutputFile(InputFileName);
      If (OutputFileName='') then
        DoError(SErrConstructingOutputFileName,[InputFileName]);
      end;
    end;
end;

begin
  ProcessCommandLine;
  If (BufSize<>0) then
    DecompressFile(InputFileName,OutputFileName,DeleteSource, BufSize)
  else
    DecompressFile(InputFileName,OutputFileName,DeleteSource);
end.
