Program comp;

uses ZLib,SysUtils,Classes;

Const 
 BufSize = 1024*128;

Procedure CompressFile(FN,AFN : String);

Var
  InF,OutF : TFileStream;
  CS : TCompressionStream;
  Buf : Pointer;
  Count : Integer;

begin
  Inf:=TFileStream.Create(FN,fmOpenRead);
  Try
    OutF:=TFileStream.Create(AFN,fmCreate);
    Try
      GetMem(Buf,BufSize);
      Try
        CS:=TCompressionStream.Create(clMax,OutF);
        Try
          Repeat
            Count:=Inf.Read(Buf^,BufSize);
            If (Count>0) then
              CS.Write(Buf^,Count);
          Until (Count<BufSize);
        Finally
          CS.Free;
        end;
      Finally
        FreeMem(Buf);
      end;
    Finally
      OutF.Free;
    end;
  Finally
    Inf.Free;
  end;
end;

begin
  CompressFile(ParamStr(1),ParamStr(2));
end.
