unit UDecomp;

interface

Const
  DefaultBufSize = 128;
  BlockSize      = 1024;

Function DetermineOutPutFile(Source : String) : String;
Procedure DecompressFile(Const Source,Dest : String; DeleteSource : Boolean; BufSize : Integer); overload;
Procedure DecompressFile(Const Source,Dest : String; DeleteSource : Boolean); overload;

implementation

uses iostream,SysUtils,Classes,ZLib;

Function CreateStream(FileName : String; ReadOnly : Boolean) : TStream;

begin
  If ReadOnly then
    begin
    if (FileName<>'') then
      Result:=TFileStream.Create(FileName,fmOpenRead)
    else
      Result:=TIOStream.Create(iosInput)
    end
  else
    begin
    If (FileName<>'') then
      Result:=TFileStream.Create(FileName,fmCreate)
    else
      Result:=TIOStream.Create(iosOutput);
    end;
end;


Procedure DecompressFile(Const Source,Dest : String; DeleteSource : Boolean; BufSize : Integer);

Var
  Buf : Pointer;
  InF,OutF : TStream;
  D : TDecompressionStream;
  BufLen,Count : Integer;

begin
  Inf:=CreateStream(Source,True);
  Try
    OutF:=CreateStream(Dest,False);
    Try
      D:=TDecompressionStream.Create(Inf);
      Try
        BufLen:=BufSize*BlockSize;
        GetMem(Buf,BufLen);
        Try
          Repeat
            Count:=D.Read(Buf^,BufLen);
            Outf.WriteBuffer(Buf^,Count);
          Until (Count<BufLen);
        Finally
          FreeMem(Buf);
        end;
      Finally
        D.Free;
      end;
    Finally
      OutF.Free;
    end;
  Finally
    Inf.Free;
  end;
  If (DeleteSource) and (Source<>'') then
    If Not DeleteFile(Source) then
      RaiseLastOSError;
end;

Procedure DecompressFile(Const Source,Dest : String; DeleteSource : Boolean);

begin
  DecompressFile(Source,Dest,DeleteSource,DefaultBufSize);
end;

Function DetermineOutPutFile(Source : String) : String;

Var
  Ext : String;

begin
  Ext:=ExtractFileExt(Source);
  // Try some common extensions
  If (CompareText(Ext,'.gbz')=0) then
    ext:='.gbk'
  else If (CompareText(Ext,'.ibz')=0) then
    ext:='.ibk'
  else If (CompareText(Ext,'.fbz')=0) then
    ext:='.fbk'
  else if (CompareText(Ext,'.gz')=0) then
    ext:=''
  else
    begin
    Result:='';
    exit;
    end;
  Result:=ChangeFileExt(Source,Ext)
end;

end.
