{ ---------------------------------------------------------------------
    $Id: svcRemoteFIBSS.pas,v 1.1 2003/10/12 15:54:27 pavel Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Remote configuration standalone Windows service

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}
unit svcRemoteFIBSS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, SvcMgr, Dialogs,
  eventlog;

type
  TFIBSSRemote = class(TService)
    ELRemote: TEventLog;
    procedure ServiceExecute(Sender: TService);
    procedure ServiceCreate(Sender: TObject);
    procedure ServiceStart(Sender: TService; var Started: Boolean);
    procedure ServiceStop(Sender: TService; var Stopped: Boolean);
    procedure ServiceDestroy(Sender: TObject);
    procedure ServicePause(Sender: TService; var Paused: Boolean);
    procedure ServiceContinue(Sender: TService; var Continued: Boolean);
  private
    { Private declarations }
    FlistenPort : Integer;
    procedure ReadConfig;
  public
    Function StartServer : Boolean;
    Function StopServer : Boolean;
    function GetServiceController: TServiceController; override;
    { Public declarations }
  end;

var
  FIBSSRemote: TFIBSSRemote;

implementation

uses cfgBackup, ctrlBackup{$ifdef win32},registry, remotefibssserver{$endif};

{$r fclel.res}

Const
  SKeyRemoteFIBSS = '\Software\FIBSS\remotefibss';
  SKeyPort        = 'Port';

Resourcestring
  SListeningOn    = 'FIBSS Remote configuration service listening on port %d';

{$R *.DFM}

procedure ServiceController(CtrlCode: DWord); stdcall;
begin
  FIBSSRemote.Controller(CtrlCode);
end;

function TFIBSSRemote.GetServiceController: TServiceController;
begin
  Result := ServiceController;
end;

procedure TFIBSSRemote.ServiceExecute(Sender: TService);
begin
  While not Terminated do
    ServiceThread.ProcessRequests(True);
end;

procedure TFIBSSRemote.ServiceCreate(Sender: TObject);
begin
  RemoteServerModule:=TRemoteServerModule.Create(Self);
  ELRemote.RegisterMessagefile('');
  ReadConfig;
  RemoteServerModule.IdServer.DefaultPort:=fListenPort;
  Try
    ELRemote.Info(SListeningOn,[FListenPort]);
  except
    // Ignore errors.
  end;
end;

procedure TFIBSSRemote.ReadConfig;

begin
{$ifdef win32}
  FListenPort:=1024;
  With TRegistry.Create do
    try
    Rootkey:=HKEY_LOCAL_MACHINE;
    Access:=Key_READ;
    If OpenKeyReadOnly(SKeyRemoteFIBSS) then
      begin
      If ValueExists(SKeyPort) then
        begin
        FListenPort:=ReadInteger(SkeyPort);
        end
      end;
    Finally
      Free;
    end;
{$else}
    // Linux code here
{$endif}
end;

procedure TFIBSSRemote.ServiceStart(Sender: TService; var Started: Boolean);
begin
  Started:=StartServer;
end;

procedure TFIBSSRemote.ServiceStop(Sender: TService; var Stopped: Boolean);
begin
  Stopped:=StopServer;
end;

procedure TFIBSSRemote.ServiceDestroy(Sender: TObject);
begin
  RemoteServerModule.IdServer.Active:=False;
  RemoteServerModule.Free;
end;

procedure TFIBSSRemote.ServicePause(Sender: TService; var Paused: Boolean);
begin
  Paused:=StopServer;
end;

procedure TFIBSSRemote.ServiceContinue(Sender: TService;
  var Continued: Boolean);
begin
  Continued:=StartServer;
end;

Function TFIBSSRemote.StartServer : Boolean;
begin
  RemoteServerModule.IdServer.Active := True;
  Result:=RemoteServerModule.IdServer.Active;
end;

Function TFIBSSRemote.StopServer : Boolean;
begin
  RemoteServerModule.IdServer.Active := False;
  Result:=Not  RemoteServerModule.IdServer.Active;
end;


end.
