{ ---------------------------------------------------------------------
    $Id: dmRemoteFIBSS.pas,v 1.1 2003/10/12 10:57:12 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Remote configuration standalone Windows service

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}
unit dmRemoteFIBSS;

interface

uses
  Libc, Classes, eventlog, SysUtils, IdBaseComponent, IdComponent,
  IdTCPServer;

type
  TService = TDataModule;

  TFIBSSRemote = class(TDataModule)
    ELRemote: TEventLog;
    procedure ServiceCreate(Sender: TObject);
    procedure ServiceDestroy(Sender: TObject);
  private
    { Private declarations }
    FTerminated : Boolean;
    FlistenPort : Integer;
    procedure ReadConfig;
  public
    procedure ServiceExecute;
    procedure ServiceStart(Sender: TService; var Started: Boolean);
    procedure ServiceStop(Sender: TService; var Stopped: Boolean);
    procedure ServicePause(Sender: TService; var Paused: Boolean);
    procedure ServiceContinue(Sender: TService; var Continued: Boolean);
    Function StartServer : Boolean;
    Function StopServer : Boolean;
    { Public declarations }
    Property Terminated : Boolean Read FTerminated;
  end;

var
  FIBSSRemote: TFIBSSRemote;

implementation

uses IniFiles,cfgRemoteFibss, remotefibssserver;

{$r fclel.res}

Resourcestring
  SListeningOn    = 'FIBSS Remote configuration service listening on port %d';

{$R *.dfm}

procedure TFIBSSRemote.ServiceExecute;
begin
  StartServer;
  While not Terminated do
    Pause;
  StopServer;
end;

procedure TFIBSSRemote.ServiceCreate(Sender: TObject);
begin
  RemoteServerModule:=TRemoteServerModule.Create(Self);

  ELRemote.RegisterMessagefile('');
  ReadConfig;
  RemoteServerModule.idServer.DefaultPort := FListenPort;
  Try
    ELRemote.Info(SListeningOn,[FListenPort]);
  except
    // Ignore errors.
  end;
end;

procedure TFIBSSRemote.ReadConfig;

begin
  FlistenPort:=DefaultFIBSSPort;
  With TMemInifile.Create(GetinifileName) do
    try
      FlistenPort:=ReadInteger(SSectionParams,SKeyPort,DefaultFIBSSPort);
    Finally
      Free;
    end;
  if (CmdLinePort<>0) then
    FlistenPort:=CmdLinePort;
end;

procedure TFIBSSRemote.ServiceStart(Sender: TService; var Started: Boolean);
begin
  Started:=StartServer;
end;

procedure TFIBSSRemote.ServiceStop(Sender: TService; var Stopped: Boolean);
begin
  Stopped:=StopServer;
end;

procedure TFIBSSRemote.ServiceDestroy(Sender: TObject);
begin
  RemoteServerModule.idServer.Active:=False;
  RemoteServerModule.Free;
end;

procedure TFIBSSRemote.ServicePause(Sender: TService; var Paused: Boolean);
begin
  Paused:=StopServer;
end;

procedure TFIBSSRemote.ServiceContinue(Sender: TService;
  var Continued: Boolean);
begin
  Continued:=StartServer;
end;

Function TFIBSSRemote.StartServer : Boolean;
begin
  RemoteServerModule.idServer.Active := True;
  Result:=RemoteServerModule.idServer.Active;
end;

Function TFIBSSRemote.StopServer : Boolean;
begin
  RemoteServerModule.idServer.Active := False;
  Result:=Not  RemoteServerModule.idServer.Active;
end;

end.
