{ ---------------------------------------------------------------------
    $Id: cfgRemoteFibss.pas,v 1.1 2003/10/12 10:57:12 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Configuration file for standalone RemoteFibbs

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}

unit cfgRemoteFibss;

interface

Uses SysUtils;

Const
  DefaultFIBSSPort   = 3070;

{$ifdef win32}
  SKeyRemoteFIBSS = '\Software\FIBSS\remotefibss';
{$else}
  SGlobalIniFileName = '/etc/remotefibss.cfg';
  SLocalIniFileName  = '.remotefibss.cfg';
  SSectionParams     = 'Params';
{$endif}

  SKeyPort        = 'Port';


Var
  CmdLinePort : Word = 0;

{$ifdef Linux}
Function GetIniFileName : String;
{$endif Linux}

Implementation

{$ifdef Linux}
uses Libc;

Function GetIniFileName : String;

begin
  Result:='';
  If (GetUID=0) then
    Result:=SGlobalIniFileName
  else
    Result:=IncludeTrailingBackslash(GetEnvironmentVariable('HOME'))+
            SLocalIniFileName;
end;
{$endif}

Procedure InitCommandLineVars;

Var
  I : Integer;

begin
  For I:=1 to ParamCount do
    If Paramstr(i)='-l' then
      If I<ParamCount then
        CmdLinePort:=StrToIntDef(ParamStr(I),0);
end;

initialization
  InitCommandLineVars;
end.
