unit FrmDecomp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ActnList;

type
  TDecompForm = class(TForm)
    BStart: TButton;
    BClose: TButton;
    EInfile: TEdit;
    LEinfile: TLabel;
    Label2: TLabel;
    SBinfile: TSpeedButton;
    SBOutfile: TSpeedButton;
    EOutfile: TEdit;
    ODin: TOpenDialog;
    SDout: TSaveDialog;
    ActionList1: TActionList;
    AStart: TAction;
    AClose: TAction;
    AInfile: TAction;
    AOutfile: TAction;
    CBDelete: TCheckBox;
    procedure AInfileExecute(Sender: TObject);
    procedure AOutfileExecute(Sender: TObject);
    procedure EInfileExit(Sender: TObject);
    procedure AStartExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AStartUpdate(Sender: TObject);
  private
    FBufSize : Integer;
    FAutoStart : Boolean;
    procedure SetoutputFileName;
    procedure ProcessCommandLine;
    procedure DoDecompressFile(ShowSucces: Boolean);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DecompForm: TDecompForm;

implementation

uses UDecomp;

resourcestring
  SErrNeedArgument = 'Option at position %d (%s) needs an argument';
  SUnknownArgument = 'Unknown argument at position %d: %s';
  SExtraArgument   = 'Extra argument at position %d: %s';
  SSucces          = 'File succesfully decompressed';

{$R *.dfm}

procedure TDecompForm.AInfileExecute(Sender: TObject);
begin
  With ODin do
    begin
    FileName:=EInfile.Text;
    if (FileName<>'') then
      InitialDir:=ExtractFilepath(FileName);
    If Execute then
      EInfile.Text:=FileName;
    SetOutputFileName;
    end;
end;

procedure TDecompForm.SetoutputFileName;

Var
  FN : String;

begin
  FN:=DetermineOutputFile(EInfile.Text);
  If (FN<>'') then
    EOutfile.Text:=FN;
end;

procedure TDecompForm.AOutfileExecute(Sender: TObject);
begin
  With SDOut do
    begin
    InitialDir:=ExtractFilePath(EInfile.Text);
    If Execute then
      EOutFile.Text:=FileName;
    end;
end;

procedure TDecompForm.EInfileExit(Sender: TObject);
begin
  if (EInfile.Text<>'') and (EOutFile.Text='') then
    SetOutputFileName;
end;

procedure TDecompForm.AStartExecute(Sender: TObject);
begin
  DoDecompressFile(True)
end;

procedure TDecompForm.DoDecompressFile(ShowSucces : Boolean);

begin
  Screen.Cursor:=crHourglass;
  Try
    DecompressFile(EInfile.Text,EoutFile.Text,cbDelete.Checked);
    If ShowSucces then
      ShowMessage(SSucces);
  Finally
    Screen.Cursor:=crDefault;
  end;
end;

Procedure TDecompForm.ProcessCommandLine;

 Function CheckOption(Index : Integer;Short,Long : String): Boolean;

  var
    O : String;

  begin
    O:=Paramstr(Index);
    Result:=(O='-'+short) or (copy(O,1,Length(Long)+3)=('--'+long+'='));
  end;

  Function OptionArg(Var Index : Integer) : String;

  Var
    P : Integer;

  begin
    if (Length(ParamStr(Index))>1) and (Paramstr(Index)[2]<>'-') then
      begin
      If Index<ParamCount then
        begin
        Inc(Index);
        Result:=Paramstr(Index);
        end
      else
        ShowMessage(Format(SErrNeedArgument,[Index,ParamStr(Index)]));
      end
    else If length(ParamStr(Index))>2 then
      begin
      P:=Pos('=',Paramstr(Index));
      If (P=0) then
        ShowMessage(Format(SErrNeedArgument,[Index,ParamStr(Index)]))
      else
        begin
        Result:=Paramstr(Index);
        Delete(Result,1,P);
        end;
      end;
  end;

Var
  I : Integer;
  S : String;

begin
  I:=0;
  FAutoStart:=False;
  While (I<ParamCount) do
    begin
    Inc(I);
    // Values.
    If Checkoption(I,'o','output') then
      EOutfile.Text:=OptionArg(I)
    else If Checkoption(I,'i','input') then
      EInfile.Text:=OptionArg(I)
    else If CheckOption(I,'b','bufsize') then
      FBufSize:=StrToIntDef(OptionArg(I),0)
    else If CheckOption(I,'l','leavesource') then
      CBDelete.Checked:=False
    else If CheckOption(I,'s','autostart') then
      FAutoStart:=True
    else
      ShowMessage(Format(SUnknownArgument,[I,ParamStr(I)]))
    end;
  If (EInfile.Text<>'') and (EOutfile.Text='') then
    SetOutputFileName;
end;

procedure TDecompForm.FormCreate(Sender: TObject);
begin
  ProcessCommandLine;
end;

procedure TDecompForm.FormActivate(Sender: TObject);
begin
  if FAutoStart then
    Try
      DodeCompressFile(False)
    Finally
      FAutoStart:=False;
    end;
end;

procedure TDecompForm.AStartUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled:=(EInfile.Text<>'') and
                               (EoutFile.Text<>'');
end;

end.
