{ ---------------------------------------------------------------------
    $Id: FrmBackupEntry.pas,v 1.4 2004/02/09 22:46:39 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Edit Form for backup configuration entry - Windows version

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}
unit FrmBackupEntry;

interface

uses
  {$IFDEF WIN32}
  Windows, Messages, SysUtils,{$ifndef ver130} Variants,{$endif} Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, ActnList, ExtCtrls,
  idTCPClient ;
  {$ELSE}
  SysUtils,Classes, QGraphics, QControls, QForms, QDialogs, QStdCtrls, QActnList, QExtCtrls, idTCPClient;
  {$ENDIF}

type
  TBackupEntryForm = class(TForm)
    LName: TLabel;
    LPath: TLabel;
    LEUserName: TLabel;
    Ename: TEdit;
    EDatabasePath: TEdit;
    EUserName: TEdit;
    EPassword: TEdit;
    LEPasswor: TLabel;
    BSelectDatabase: TButton;
    ActionList1: TActionList;
    AOk: TAction;
    ACancel: TAction;
    BSelectBackupFile: TButton;
    EBackupFile: TEdit;
    Label1: TLabel;
    BSelectLogFile: TButton;
    ELogFile: TEdit;
    Label2: TLabel;
    PButtons: TPanel;
    BOk: TButton;
    BCancel: TButton;
    GBOptions: TGroupBox;
    CBIgnoreChecksums: TCheckBox;
    CBIgnoreLimbo: TCheckBox;
    CBMetadataOnly: TCheckBox;
    CBNoGarbageCollection: TCheckBox;
    CBNonTransportable: TCheckBox;
    CBConvertExtTables: TCheckBox;
    EServerName: TEdit;
    Label3: TLabel;
    ODDatabase: TOpenDialog;
    SDbackupfile: TSaveDialog;
    SDLog: TSaveDialog;
    GroupBox1: TGroupBox;
    CBSkip: TCheckBox;
    CBCompress: TCheckBox;
    CBDaysOnly: TCheckBox;
    CBMonday: TCheckBox;
    CBThursday: TCheckBox;
    CBTuesday: TCheckBox;
    CBFriday: TCheckBox;
    CBSaturday: TCheckBox;
    CBSunday: TCheckBox;
    CBWednesday: TCheckBox;
    procedure SelectDatabaseFile(Sender: TObject);
    procedure AOkUpdate(Sender: TObject);
    procedure ACancelExecute(Sender: TObject);
    procedure AOkExecute(Sender: TObject);
    procedure SelectBackupFile(Sender: TObject);
    procedure SelectLogFile(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CBDaysOnlyClick(Sender: TObject);
  private
    CBDays : Array[0..6] of TCheckBox;
    function SaveEntry : Boolean;
    function ReadEntry: Boolean;
    function GetDays: Integer;
    procedure SetDays(Value: Integer);
    { Private declarations }
  public
    { Public declarations }
    idClient:TidTCPClient;
  end;

var
  BackupEntryForm: TBackupEntryForm;

Resourcestring
  SEditEntry   = 'Edit backup entry';
  SEditDefault = 'Edit backup defaults';

implementation

uses cfgBackup,remotefibssclient;

{$IFDEF WIN32}
  {$R *.dfm}
{$ELSE}
  {$R *.xfm}
{$ENDIF}

procedure TBackupEntryForm.SelectDatabaseFile(Sender: TObject);


begin
  With ODDatabase do
    begin
    FileName:=EDatabasePath.Text;
    If Execute then
      EDatabasePath.Text:=FileName;
    end;
end;

procedure TBackupEntryForm.AOkUpdate(Sender: TObject);
begin
  (Sender as Taction).Enabled:=(EName.Text<>'') and
                               ((EName.Text=SDefault) or (EDatabasePath.Text<>''));
end;

procedure TBackupEntryForm.ACancelExecute(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TBackupEntryForm.AOkExecute(Sender: TObject);

begin
  If SaveEntry then
    ModalResult:=mrOk;
end;

Function TBackupEntryForm.SaveEntry : Boolean;

Var
  Config : TBackupConfig;

  Procedure Setopt(Cb : TCheckBox; O : TBackupOption);

  begin
    If CB.Checked then
      Include(Config.Options,O);
  end;

begin
  With Config do
    begin
    ServerName:=EServerName.Text;
    DatabasePath:=EDatabasePath.Text;
    BackupFile:=EBackupFile.Text;
    UserName:=EUserName.Text;
    Password:=EPassWord.Text;
    LogFileName:=ELogFile.Text;
    Options:=[];
    SetOpt(CBIgnoreChecksums,boIgnoreChecksums);
    SetOpt(CBIgnoreLimbo,boIgnoreLimbo);
    SetOpt(CBMetadataOnly,boMetadataOnly);
    SetOpt(CBNoGarbageCollection,boNoGarbageCollection);
    SetOpt(CBNonTransportable,boNonTransportable);
    SetOpt(CBConvertExtTables,boConvertExtTables);
    Compressbackup:=CBCompress.Checked;
    Skip:=CBSkip.Checked;
    DaysOfWeek:=GetDays;
    end;
  If (idClient<>Nil) then
    Result:=WriteRemoteConfig(idClient,ENAme.Text,Config)
  else
    Result:=WriteConfig(EName.Text,Config)
end;

procedure TBackupEntryForm.SelectBackupFile(Sender: TObject);
begin
  With SDBackupfile do
    begin
    FileName:=EBackupFile.Text;
    If Execute then
      EBackupFile.Text:=FileName;
    end;
end;

procedure TBackupEntryForm.SelectLogFile(Sender: TObject);
begin
  With SDLog do
    begin
    FileName:=ELogFile.Text;
    If Execute then
      ELogFile.Text:=FileName;
    end;
end;

procedure TBackupEntryForm.FormShow(Sender: TObject);
begin
  If Not EName.Enabled then
    begin
    If (EName.Text=SDefault) then
      begin
      Caption:=SEditDefault;
      EDatabasePath.Enabled:=False;
      BSelectDatabase.Enabled:=False;
      end
    else
      Caption:=SEditEntry;
    ReadEntry;
    end;
end;

Function TBackupEntryForm.ReadEntry : Boolean;

Var
  Config : TBackupConfig;

  Procedure Setopt(Cb : TCheckBox; O : TBackupOption);

  begin
    CB.Checked:=(O in Config.Options);
  end;

begin
  If (idClient<>Nil) then
    Result:=ReadRemoteConfig(idClient,ENAme.Text,Config)
  else
    Result:=ReadConfig(EName.Text,Config);
  If Result then
    With Config do
      begin
      EServerName.Text:=ServerName;
      EDatabasePath.Text:=DatabasePath;
      EBackupFile.Text:=BackupFile;
      EUserName.Text:=UserName;
      EPassWord.Text:=Password;
      ELogFile.Text:=LogFileName;
      SetOpt(CBIgnoreChecksums,boIgnoreChecksums);
      SetOpt(CBIgnoreLimbo,boIgnoreLimbo);
      SetOpt(CBMetadataOnly,boMetadataOnly);
      SetOpt(CBNoGarbageCollection,boNoGarbageCollection);
      SetOpt(CBNonTransportable,boNonTransportable);
      SetOpt(CBConvertExtTables,boConvertExtTables);
      CBCompress.Checked:=CompressBackup;
      CBSkip.Checked:=Skip;
      SetDays(DaysOfWeek);
      end;
end;

procedure TBackupEntryForm.FormCreate(Sender: TObject);
begin
  CBDays[0]:=CBSunday;
  CBDays[1]:=CBMonday;
  CBDays[2]:=CBTuesday;
  CBDays[3]:=CBWednesday;
  CBDays[4]:=CBThursday;
  CBDays[5]:=CBFriday;
  CBDays[6]:=CBSaturday;
end;

Procedure TBackupEntryForm.SetDays(Value : Integer);

Var
  B : Byte;

begin
  CBDaysOnly.Checked:=(Value<>0);
  For B:=0 to 6 do
    begin
    CBDays[B].Enabled:=(Value<>0);
    CBDays[B].Checked:=((Value and (1 shl B))<>0)
    end;
end;

Function TBackupEntryForm.GetDays : Integer;

Var
  B : Byte;

begin
  Result:=0;
  If CBDaysOnly.Checked then
    For B:=0 to 6 do
      If CBDays[B].Checked then
        Result:=Result or (1 shl B)
end;

procedure TBackupEntryForm.CBDaysOnlyClick(Sender: TObject);

Var
  B : Byte;

begin
  For B:=0 to 6 do
    CBDays[B].Enabled:=CBDaysOnly.Checked;
end;

end.
