{ ---------------------------------------------------------------------
    $Id: fibss.dpr,v 1.2 2003/12/14 15:06:07 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Firebird/Interbase Backup Scheduling Service main program

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}
program fibss;

uses
  SvcMgr,
  Forms,
  Classes,
  SysUtils,
  Windows,
  WinSvc,
  ServiceManager,
  svcBackup in 'svcBackup.pas' {FIBService: TService},
  thrBackup in '..\..\common\thrBackup.pas',
  CfgBackup in '..\..\common\CfgBackup.pas',
  frmManualBackup in 'frmManualBackup.pas' {ManualBackupForm};

{$R *.RES}

Var
  Installing : Boolean;

function IsInstalling: Boolean;
begin
  Result := FindCmdLineSwitch('INSTALL',['-','/'], True) or
            FindCmdLineSwitch('UNINSTALL',['-','/'], True);
end;

function RunManual : Boolean;

begin
  Result := FindCmdLineSwitch('MANUAL',['-','/'], True) or
            FindCmdLineSwitch('M',['-','/'], True);
end;

begin
  Installing:=IsInstalling;
  if Installing or Not RunManual then
  begin
    SvcMgr.Application.Initialize;
    SvcMgr.Application.Title := 'Firebird/Interbase backup schedule service';
    svcMgr.Application.CreateForm(TFIBService, FIBService);
    svcMgr.Application.Run;
  end
  else
  begin
    Forms.Application.ShowMainForm := True;
    Forms.Application.Title:='Firebird/Interbase backup schedule service';
    Forms.Application.Initialize;
    Forms.Application.CreateForm(TManualBackupForm, ManualBackupForm);
    Forms.Application.Run;
  end;
end.
