{ ---------------------------------------------------------------------
    $Id: frmManualBackup.pas,v 1.1 2003/10/12 10:58:09 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Manual backup run - main screen.

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}
unit frmManualBackup;

interface

uses
  LibC, SysUtils, Variants, Classes, QForms,
  QDialogs, QStdCtrls, QControls;

type
  TManualBackupForm = class(TForm)
    BStart: TButton;
    Mlog: TMemo;
    LMlog: TLabel;
    procedure BStartClick(Sender: TObject);
  private
    { Private declarations }
    Procedure Log(MSg : String);
    Procedure ThreadFinished(Sender : TObject);
  public
    { Public declarations }
  end;

var
  ManualBackupForm: TManualBackupForm;

implementation

uses thrBackup;

{$R *.dfm}

resourcestring
  SFinishedBackups ='Finished %d backups in total time %s';

procedure TManualBackupForm.BStartClick(Sender: TObject);
begin
  MLog.Clear;
  With TBackupThread.Create(true) do
    begin
    Verbose:=True;
    OnInfoMessage:=Self.log;
    OnErrorMessage:=Self.log;
    Onterminate:=ThreadFinished;
    Resume;
    end;
end;

procedure TManualBackupForm.Log(MSg: String);
begin
  MLog.Lines.Add(Msg)
end;

procedure TManualBackupForm.ThreadFinished(Sender: TObject);

Var
  S : String;

begin
  With (Sender as TBackupThread) do
    S:=Format(SFinishedBackups,
              [TotalFiles,FormatDateTime('hh:nn:ss',TotalTime)]);
  Self.Log(S);
end;

end.

