{ ---------------------------------------------------------------------
    $Id: fibss.dpr,v 1.2 2003/10/13 19:48:13 michael Exp $
    Copyright (c) 2003 by Michael Van Canneyt

    Firebird/Interbase Backup Scheduling Service main program

    See the file COPYING.TXT, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ---------------------------------------------------------------------}

program fibss;

{ Define NOGUI if an executable is required which can run without X}
{$include fibssdef.inc}

{ Hint for Kylix IDE }
{%File 'fibssdef.inc'}


uses
  SysUtils,
  svcBackup in 'svcBackup.pas' {FIBService: TDataModule},
{$ifndef NOGUI}
  QForms,
  frmManualBackup in 'frmManualBackup.pas' {ManualBackupForm},
{$endif}
  CfgBackup in '../../common/CfgBackup.pas',
  thrBackup in '../../common/thrBackup.pas';


Resourcestring
  SErrNoGUI = 'This version of fibss does not have GUI capabilities.';
{$R *.res}

Function RunManual : Boolean;

begin
  Result:=FindCmdLineSwitch('manual',['-'],False)
          or FindCmdLineSwitch('m',['-'],False);
end;

begin
  If RunManual then
    begin
{$ifdef NOGUI}
    Writeln(SErrNoGUI);
    Halt(1);
{$else}
    Application.Title:='Firebird/Interbase backup schedule service';
    Application.Initialize;
    Application.CreateForm(TManualBackupForm, ManualBackupForm);
    Application.Run;
{$endif}
    end
   else
    begin
    FIBService:=TFIBService.Create(Nil);
    Try
      FIBService.ServiceExecute;
    finally
      FreeAndNil(FIBService)
    end;
    end;
end.
