unit frmmain;

interface

uses
  Windows, Messages, SysUtils, {$ifndef ver130}Variants,{$endif} Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ServiceManager, ActnList, ExtCtrls,winsvc;

type
  TMainForm = class(TForm)
    SGMain: TStringGrid;
    SMMain: TServiceManager;
    ActionList1: TActionList;
    ARefresh: TAction;
    ARegister: TAction;
    AUnregister: TAction;
    ADependencies: TAction;
    Panel1: TPanel;
    BRefresh: TButton;
    BRegister: TButton;
    Button1: TButton;
    BDependencies: TButton;
    LRegistered: TLabel;
    BPause: TButton;
    APause: TAction;
    BContinue: TButton;
    AContinue: TAction;
    Button2: TButton;
    AStart: TAction;
    BStop: TButton;
    AStop: TAction;
    BSetStartupType: TButton;
    ASetStartupType: TAction;
    procedure FormShow(Sender: TObject);
    procedure SMConnected(Sender: TObject);
    procedure ARefreshExecute(Sender: TObject);
    procedure SMMainAfterRefresh(Sender: TObject);
    procedure ARegisterExecute(Sender: TObject);
    procedure HaveSelected(Sender: TObject);
    procedure AUnregisterExecute(Sender: TObject);
    procedure ADependenciesExecute(Sender: TObject);
    procedure APauseExecute(Sender: TObject);
    procedure APauseUpdate(Sender: TObject);
    procedure AContinueUpdate(Sender: TObject);
    procedure AContinueExecute(Sender: TObject);
    procedure AStartExecute(Sender: TObject);
    procedure AStartUpdate(Sender: TObject);
    procedure AStopUpdate(Sender: TObject);
    procedure AStopExecute(Sender: TObject);
    procedure ASetStartupTypeExecute(Sender: TObject);
  private
    procedure RefreshGrid;
    function CheckState(AControl, AState: DWord): Boolean;
    function CurrentService: String;
    procedure RefreshCurrent;
    procedure SetRowData(Row: Integer);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses frmRegisterService,frmStartup;

resourcestring
  SNodependencies = 'No dependencies for service "%s".';
  SDependenciesOf = 'Dependencies of service "%s":'#13#10'%s';
  SConfirmUnregister = 'Are you sure you want to unregister service "%s"?';

{$R *.dfm}

procedure TMainForm.RefreshGrid;


Var
  I : Integer;

begin
  With SMMain do
    begin
    With Services do
      begin
      If Count=0 then
        SGMain.RowCount:=2
      else
        SGMain.RowCount:=Count+1;
      For I:=1 to Count do
        SetRowData(I);
      end;
    end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  SGMAin.Cells[0,0]:='Short name';
  SGMAin.Cells[1,0]:='Long name';
  SGMAin.Cells[2,0]:='State';
  SGMAin.Cells[3,0]:='Control';
  SGMAin.Cells[4,0]:='Type';
  SGMAin.Cells[5,0]:='Interactive';
end;

procedure TMainForm.SMConnected(Sender: TObject);
begin
  (Sender as TAction).Enabled:=SMMain.Connected;
end;

procedure TMainForm.ARefreshExecute(Sender: TObject);
begin
  SMMain.Refresh;
end;

procedure TMainForm.SMMainAfterRefresh(Sender: TObject);
begin
  RefreshGrid;
end;

procedure TMainForm.ARegisterExecute(Sender: TObject);
begin
  With TRegisterServiceForm.Create(Self) do
    begin
    ServiceManager:=SMMain;
    If ShowModal=mrOK then
      Refresh;
    end;
end;

procedure TMainForm.HaveSelected(Sender: TObject);
begin
  (Sender as TAction).Enabled:=(SMMain.Connected) and
                               (SGMain.Row<>0);
end;

procedure TMainForm.AUnregisterExecute(Sender: TObject);

Var
  S : String;

begin
  With SGMain,SMMain do
    begin
    S:=Services[Row-1].ServiceName;
    If MessageDlg(Format(SConfirmUnregister,[S]),mtInformation,mbOKCancel,0)=mrOK then
      begin
      UnregisterService(S);
      Refresh;
      end;
    end;
end;

procedure TMainForm.ADependenciesExecute(Sender: TObject);

Var
  Msg,N : String;
  List : TStringList;

begin
  List:=TStringList.Create;
  Try
    With SGMain,SMMAin do
      begin
      N:=Services[Row-1].ServiceName;
      ListDependentServices(N,SERVICE_STATE_ALL,List);
      end;
    If List.Count=0 then
      Msg:=Format(SNodependencies,[N])
    else
      Msg:=Format(SDependenciesOf,[N,List.Text]);
    MessageDlg(Msg,mtInformation,[mbOk],0);
  Finally
    List.Free;
  end;
end;

procedure TMainForm.APauseExecute(Sender: TObject);

Var
  N : String;

begin
  With SGMain,SMMAin do
    begin
    N:=Services[Row-1].ServiceName;
    PauseService(N);
    Refresh;
    end;
end;

Function TMainForm.CheckState(AControl,AState : DWord) : Boolean;

begin
  Result:=(SMMain.Connected) and (SGMain.Row<>0);
  If Result then
    With SGMain,SMMain.Services[Row-1] do
      Result:=((AControl=0) or
               ((ControlsAccepted and AControl)<>0)) and
              (CurrentState=AState);
end;


procedure TMainForm.APauseUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled:=
    CheckState(SERVICE_ACCEPT_PAUSE_CONTINUE,SERVICE_RUNNING);
end;

procedure TMainForm.AContinueUpdate(Sender: TObject);

begin
  (Sender as TAction).Enabled:=
    CheckState(SERVICE_ACCEPT_PAUSE_CONTINUE,SERVICE_PAUSED);
end;

procedure TMainForm.AContinueExecute(Sender: TObject);

Var
  N : String;

begin
  With SGMain,SMMAin do
    begin
    N:=Services[Row-1].ServiceName;
    ContinueService(N);
    Refresh;
    end;
end;

procedure TMainForm.AStartExecute(Sender: TObject);

Var
  N : String;

begin
  With SGMain,SMMAin do
    begin
    N:=Services[Row-1].ServiceName;
    StartService(N,Nil);
    Refresh;
    end;
end;

procedure TMainForm.AStartUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled:=
    CheckState(0,SERVICE_STOPPED);
end;

procedure TMainForm.AStopUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled:=
    CheckState(SERVICE_ACCEPT_STOP,SERVICE_RUNNING);
end;

procedure TMainForm.AStopExecute(Sender: TObject);
Var
  N : String;

begin
  With SGMain,SMMAin do
    begin
    N:=Services[Row-1].ServiceName;
    StopService(N,False);
    Refresh;
    end;
end;

Function TMainForm.CurrentService : String;

begin
  Result:='';
  If (SGMain.Row>0) then
    Result:=SMMain.Services[SGMain.Row-1].ServiceName;
end;

Procedure TMainForm.SetRowData(Row : Integer);

begin
  With SMMain.Services[Row-1] do
    begin
    SGMain.Cells[0,Row]:=ServiceName;
    SGMain.Cells[1,Row]:=DisplayName;
    SGMain.Cells[2,Row]:=ServiceStateToString(CurrentState);
    SGMain.Cells[3,Row]:=ControlsAcceptedToString(ControlsAccepted);
    SGMain.Cells[4,Row]:=ServiceTypeToString(ServiceType);
    If IsInteractiveService(ServiceType) then
      SGMain.Cells[5,Row]:='Yes'
    else
      SGMain.Cells[5,Row]:='No'
    end;
end;

procedure TMainForm.RefreshCurrent;

begin
  SMMain.RefreshServiceStatus(CurrentService);
  SetRowData(SGMain.Row);
end;

procedure TMainForm.ASetStartupTypeExecute(Sender: TObject);
begin
  With TStartupTypeForm.Create(Self) do
    Try
      ServiceManager:=Self.SMMain;
      ServiceName:=CurrentService;
      If ShowModal=mrOK then
        RefreshCurrent;
    Finally
      Free;
    end;
end;

end.
