unit frmStartup;

interface

uses
  Windows, Messages, SysUtils, {$ifndef ver130}Variants, {$endif}Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,ServiceManager,frmService;

type
  TStartupTypeForm = class(TServiceForm)
    BOK: TButton;
    BCancel: TButton;
    RGStartType: TRadioGroup;
    LService: TLabel;
    procedure BOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FServiceName : String;
  public
    { Public declarations }
    Property ServiceName : String Read FServiceName write FServiceName;
  end;

var
  StartupTypeForm: TStartupTypeForm;

implementation

{$R *.dfm}

procedure TStartupTypeForm.BOKClick(Sender: TObject);
begin
  ServiceManager.SetStartupType(FServiceName,StartTypes[RGStartType.ItemIndex]);
  ModalResult:=MrOK;
end;

procedure TStartupTypeForm.FormShow(Sender: TObject);

Var
  SE : TServiceEntry;
  Cfg : TServiceDescriptor;
  I : Integer;

begin
  SE:=ServiceManager.Services.ServiceByName(FServiceName);
  With LService do
    Caption:=Caption+SE.DisplayName;
  ServiceManager.QueryServiceConfig(FServiceName,Cfg);
  For I:=0 to 4 do
    If StartTypes[i]=CFG.StartType then
      RGStartType.ItemIndex:=I;
end;

end.
