unit frmSimpleClient;

interface

uses
  Windows, Messages, SysUtils, {$ifndef ver130}Variants, {$endif}Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TTSimpleClientForm = class(TForm)
    BGetTime: TButton;
    MLog: TMemo;
    procedure BGetTimeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TSimpleClientForm: TTSimpleClientForm;

implementation

{$R *.dfm}

procedure TTSimpleClientForm.BGetTimeClick(Sender: TObject);

Const
  PipeName = '\\.\pipe\SimpleService';

Var
  HPipe: THandle;
  D : TDateTime;
  BytesRead : DWord;

begin
  If WaitNamedPipe(PipeName,NMPWAIT_USE_DEFAULT_WAIT) then
    begin
    HPipe:=CreateFile(PipeName,GENERIC_READ,0,Nil,OPEN_EXISTING,0,0);
    If (HPipe<>INVALID_HANDLE_VALUE) then
      begin
      ReadFile(HPipe, D, sizeof(D),BytesRead,NiL);
      CloseHandle(HPipe);
      MLog.Lines.add('Got time : '+DateTimeToStr(D));
      end;
    end;
end;

end.
