unit frmRegisterService;

interface

uses
  Windows, Messages, SysUtils, {$ifndef ver130}Variants, {$endif}Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ActnList, servicemanager,winsvc,frmService;

type
  TRegisterServiceForm = class(TServiceForm)
    EName: TEdit;
    EDisplayName: TEdit;
    BRegister: TButton;
    LName: TLabel;
    Label2: TLabel;
    CBServiceType: TComboBox;
    Label3: TLabel;
    CBStartType: TComboBox;
    Label4: TLabel;
    CBInteractive: TCheckBox;
    ECommandLine: TEdit;
    BExe: TButton;
    CBErrorType: TComboBox;
    Label5: TLabel;
    Label6: TLabel;
    EUserName: TEdit;
    EPassword: TEdit;
    CBloadGroup: TComboBox;
    Label7: TLabel;
    Label1: TLabel;
    Label8: TLabel;
    BCancel: TButton;
    ALRegister: TActionList;
    ARegister: TAction;
    ACancel: TAction;
    ODExe: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure BExeClick(Sender: TObject);
    procedure ARegisterUpdate(Sender: TObject);
    procedure ACancelExecute(Sender: TObject);
    procedure ARegisterExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RegisterServiceForm: TRegisterServiceForm;

implementation

{$R *.dfm}

uses registry;

Resourcestring
  SErrReadingList = 'An error occurred while reading list of service groups:'#13#10'%s.';
  SErrOpeningList = 'Could not open the registry key with the list of load groups.';

procedure TRegisterServiceForm.FormShow(Sender: TObject);

Var
  S : String;
  Buf : Array[0..2047] of Char;
  i,L : Integer;

begin
  With TRegistry.Create do
    Try
      RootKey:=HKEY_LOCAL_MACHINE;
      If OpenkeyReadOnly('\System\CurrentControlSet\Control\ServiceGroupOrder') then
        Try
          FillChar(Buf,SizeOf(Buf),0);
          L:=ReadBinaryData('List',Buf,SizeOf(Buf));
          For I:=0 to L-2 do
            If (Buf[i]=#0) then
              Buf[i]:='/';
          S:=Buf;
          CBLoadGroup.Items.BeginUpdate;
          Try
            While (S<>'') do
              begin
              I:=Pos('/',S);
              If I=0 then
                I:=Length(S)+1;
              If (I>1) then
                CBLoadGroup.Items.Add(Copy(S,1,I-1));
              System.Delete(S,1,I);
              end;
          finally
            CBLoadGroup.Items.EndUpdate;
          end;
        Except
          On E : Exception do
            MessageDLg(Format(SErrReadingList,[E.Message]),mtError,[mbOK],0);
        end
      else
        MessageDLg(SErrOpeningList,mtError,[mbOK],0);
    Finally
      Free;
    end;
end;

procedure TRegisterServiceForm.BExeClick(Sender: TObject);

Var
  FN : String;

begin
  With ODExe do
    if execute then
      begin
      FN:=FileName;
      if Pos(' ',FN)<>0 then
        FN:='"'+FN+'"';
      ECommandLine.Text:=FN;
      end;
end;

procedure TRegisterServiceForm.ARegisterUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled:=(EName.Text<>'') and
                               (EDisplayName.Text<>'') and
                               (ECommandLine.Text<>'') and
                               (CBServiceType.ItemIndex<>-1) and
                               (CBStartType.ItemIndex<>-1) and
                               (CBErrorType.ItemIndex<>-1);
end;

procedure TRegisterServiceForm.ACancelExecute(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TRegisterServiceForm.ARegisterExecute(Sender: TObject);


Var
  SD : TServiceDescriptor;
  DW : DWord;

begin
  FillChar(SD,SizeOf(SD),0);
  DW:=ServiceTypes[CBServiceType.ItemIndex];
  If CBInteractive.Checked then
    DW:=DW or SERVICE_INTERACTIVE_PROCESS;
  SD.Name:=EName.Text;
  SD.DisplayName:=EDisplayName.Text;
  SD.CommandLine:=ECommandLine.Text;
  SD.StartType:=StartTypes[CBStartType.ItemIndex];
  SD.ServiceType:=DW;
  SD.DesiredAccess:=SERVICE_ALL_ACCESS;
  SD.ErrorControl:=StartErrors[CBErrorType.ItemIndex];
  SD.LoadOrderGroup:=CBLoadGroup.Text;
  SD.UserName:=EUserName.Text;
  SD.Password:=EPassword.Text;
  ServiceManager.RegisterService(SD);
  ModalResult:=mrOk;
end;

end.
