#!/bin/sh
#
#
# Don't edit this file when installing. 
# Everything can be set when the script is run.
#
#######################################################################
# Configuration
#######################################################################
# Release Version
#
VERSION=1.1

#
# tar.gz file that contains binary installation.
#
TARFILE=fibss-nox-${VERSION}.tar.gz

#
# Name of real binaries
#
FIBSSBIN=fibss.bin
REMOTEFIBSSBIN=remotefibss.bin

#
# Name of run scripts.
#
FIBSS=fibss
REMOTEFIBSS=remotefibss
#
#default installation directory.
#
DEFAULTINSTALLDIR=/opt/fibss11

#######################################################################
# some useful functions
# ask displays 1st parameter, and ask new value for variable, whose name is
# in the second parameter.
ask ()
{
askvar=$2
eval old=\$$askvar
eval echo -n \""$1 [$old] : "\" 
read $askvar
eval test -z \"\$$askvar\" && eval $askvar=\'$old\'
}
#
# yesno gives 1 on no, 0 on yes $1 gives text to display.
#
yesno ()
{
  while true; do
  echo -n "$1 (Y/n) ? "
  read ans
  case X$ans in
   X|Xy|XY) return 0;;
   Xn|XN) return 1;;
  esac
  done
}
#
# Untar files ($3,optional) from  file ($1) to the given directory ($2)
#
unztar ()
{
 tar -xzf $HERE/$1 --directory $2 $3
}
#
# Make all the necessary directories to get $1
#
makedirhierarch ()
{
  OLDDIR=`pwd`
  case $1 in
    /*) cd /;;
  esac
  OLDIFS=$IFS;IFS=/;eval set $1; IFS=$OLDIFS
  for i
  do
    test -d $i || mkdir $i || break
    cd $i ||break
  done
  cd $OLDDIR
}
#
# check to see if something is in the path
#
checkpath ()
{
 ARG=$1
 OLDIFS=$IFS; IFS=":";eval set $PATH;IFS=$OLDIFS
 for i
 do
   if [ $i = $ARG ]; then
     return 0
   fi
 done 
 return 1
}

# --------------------------------------------------------------------------
# welcome message.
#

clear
echo "This shell script will attempt to install Time To Backup for linux,"
echo "version $VERSION"
echo 

# Here we start the thing.
HERE=`pwd`

INSTALLDIR=$DEFAULTINSTALLDIR
ask "Install in directory" INSTALLDIR
makedirhierarch $INSTALLDIR
#
# Unpack.
#
echo Unpacking Time To Backup...
unztar $TARFILE $INSTALLDIR

#
# Create run script.
#
echo "Creating daemon run script (${INSTALLDIR}/bin/$FIBSS)" .
echo
cat >${INSTALLDIR}/bin/$FIBSS <<EOS
#!/bin/sh
#
# Set location
#
FIBSSDIR=$INSTALLDIR
#
# Set library path
#
if [ -z "\$LD_LIBRARY_PATH" ]; then
  LD_LIBRARY_PATH=\${FIBSSDIR}/lib
  export LD_LIBRARY_PATH;
else
  LD_LIBRARY_PATH=\$FIBSSDIR/lib:\${LD_LIBRARY_PATH}
fi
#
# Start.
#
exec \$FIBSSDIR/bin/$FIBSSBIN \$*
#
#end of script
EOS
#
# Make script executable
#
chmod 755 ${INSTALLDIR}/bin/$FIBSS

echo "Creating remote manager daemon script (${INSTALLDIR}/bin/$REMOTEFIBSS)"
echo
cat >${INSTALLDIR}/bin/$REMOTEFIBSS <<EOS
#!/bin/sh
#
# Set installation location
#
FIBSSDIR=$INSTALLDIR
#
# Set library path
#
if [ -z "\$LD_LIBRARY_PATH" ]; then
  LD_LIBRARY_PATH=\${FIBSSDIR}/lib
  export LD_LIBRARY_PATH;
else
  LD_LIBRARY_PATH=\$FIBSSDIR/lib:\${LD_LIBRARY_PATH}
fi
#
# Start.
#
exec \$FIBSSDIR/bin/$REMOTEFIBSSBIN \$*
#
#end of script
#
EOS
#
# Make script executable
#
chmod 755 ${INSTALLDIR}/bin/$REMOTEFIBSS

#
# Install symbolic link.
#
if yesno "Install symbolic link in a directory in the PATH"; then
  EXECDIR=/usr/local/bin 
  ask "Install link in directory" EXECDIR
  #
  # Remove any existing link. 
  #
  echo Installing symbolic link...
  rm -f $EXECDIR/$FIBSS
  #
  # install new link.
  #
  ln -sf ${INSTALLDIR}/bin/$FIBSS  $EXECDIR/$FIBSS
fi
#
# Install startup script
#
SCRIPTINSTALLED=NO
IDBIN=`which id`
if [ -x "$IDBIN" ]; then
  USERID=`$IDBIN -u`
  if [ "$USERID" = 0 ]; then
    echo
    echo The install script can attempt to install a startup script. 
    echo This script ensures that 'Time to backup' is started each time the
    echo computer is booted. The script is tested on SuSE Linux, but should
    echo work on most other systems as well.
    echo
    if yesno "Install fibss runlevel startup script"; then
      if [ -d /etc/init.d ]; then
         echo Creating script.
         sed s+/usr/local/bin+$INSTALLDIR/bin+ < rcfibss >/etc/init.d/fibss
         if [ $? = 0 ]; then
           echo Making script executable.
           chmod 755 /etc/init.d/fibss
           if [ $? = 0 ]; then
             echo Calling insserv to install the script.
             insserv /etc/init.d/fibss
             if [ $? = 0 ]; then             
               echo Making a symbolic link.
               ln -fs /etc/init.d/fibss /usr/sbin/rcfibss
               if [ $? = 0 ]; then
                 SCRIPTINSTALLED=YES
               else
                 echo Failed to create link.
               fi
             else
               echo Failed to install script.
             fi
           else
             echo Failed to make script executable.
           fi
         else
           echo Failed to create script !
         fi
      else
        echo Failed to determine runlevel directory.
        echo Please copy and install the script manually.
      fi
    fi
  fi
fi
#
# Start daemon ?
#
if yesno "Should the scheduler be started now"; then
  if [ $SCRIPTINSTALLED = YES ]; then
    echo Attempting to install using runlevel script
    /etc/init.d/fibss start
  else
    echo Attempting to run installed binary directly.
    ${INSTALLDIR}/bin/fibss    
  fi
fi
#
# All done.
#
echo "Time to Backup (no X) for Linux version $VERSION is installed." 
echo "You can start the service program with the $FIBSS command."
#
#